# Changelog

## v0.9

## features
- rewrite to RPython for performance
- variables scopes are now their own type: environment (instead of dictionary)
- optimized the encoding of builtin datatypes, class instances and stack frames
- improved error stacktraces
- compile preloaded builtin libraries to reduce startup time
- rollback (run) builtin (cannot be compiled under RPython yet)

## bug fixes
- removed string-concat global
- instance attributes can no longer be set if they are not declared in the class
- the integer parser now parses full literals when reporting syntax errors

## v0.8

### features
- add (apply) builtin
- add generalized (set) macro and use it for (defclass)-generated setters
- add metadata and docstrings to def and defmacro
- add (run) builtin to run shell commands from Antilisp
- new code generation module: line-blocks

### bug fixes
- (at) and (set-at) did not support dictionaries
- (load) imports are now relative to the file being executed
- functions and macros are now represented by their definition (rather than their macro expansion output)
- less worse stacktraces during errors
- better test system for modules and Antilisp errors

## v0.7

### features
- add missing builtins: is-cell
- add generic (in)
- add metadata property to values
- add source code and name as metadata in class definition
- add getter and setter generation in defclass
- builtins now make use of the virtual stack and resume asynchronously after starting sub-tasks in the interpreter
- add stacktrace printing capabilities during crashes

### bug fixes
- errors: errors were not raised correctly by the builtins
- (repr) and (to-string): calling (repr) or (to-string) on types with no method would raise errors
- (repr): representing dictionaries did not call user-defined methods on recursion
- generics: (defgeneric) initialized the method store during macro expansion instead of during execution


## v0.6

### features
- new stackless interpreter

### bug fixes
- no more stack limit


## v0.5

### features
- define (is-subclass)

### bug fixes
- builtins: (is-instance) did not check parent classes
- builtins: (print) did not use the user-defined (to-string) generic when casting its arguments
- builtins: the (to-string) generic did not process all the builtin datatypes
- builtins: the `class` datatype was not exposed like other datatypes
- builtins: (repr) did not display classes
- builtins: (reverse) did not return the correct result, which also affected list concatenation with (+)
- tests: improve test coverage of the bootstrapped builtins


## v0.4

### features
- *github actions library* with example
- (repr) and (to-string) are now generics
- define generics (length), (at), (iter)
- extend generic (+) for list concatenation
- define (sum), (+s) and (reverse)
- reduce needed parenthesis in (for) and (cond)
- document builtins with docstrings
- add (defclass) wrapper for class and constructor definition
- add parser support for escaping common characters (\n, \\, \") in string literals

### bug fixes
- parser: closing parenthesis were not found after a comment
- parser: the symbol parser would include # or ; as part of the symbols
- builtins: typing error on (join)
- builtins: (is-symbol) was not defined
- builtins: (has-key) was missing for dictionary manipulation
